/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.db;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.db.DBIteratorImpl;
import de.willuhn.datasource.db.DBServiceImpl;
import de.willuhn.datasource.db.ObjectMetaCache;
import de.willuhn.datasource.db.types.Type;
import de.willuhn.datasource.db.types.TypeRegistry;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.Event;
import de.willuhn.datasource.rmi.Listener;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.Session;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public abstract class AbstractDBObject
extends UnicastRemoteObject
implements DBObject {
    private String id;
    private HashMap properties = new HashMap();
    private HashMap origProperties = new HashMap();
    private HashMap types = new HashMap();
    private static transient Session transactions = new Session(300000L);
    private HashMap foreignObjectCache = new HashMap();
    private transient DBServiceImpl service = null;
    private transient Connection conn = null;
    private transient ArrayList deleteListeners = null;
    private transient ArrayList storeListeners = null;
    private boolean upper = false;
    private boolean created = false;

    protected void setService(DBServiceImpl service) throws Exception {
        this.service = service;
        this.conn = service.getConnection();
        if (this.conn == null) {
            throw new SQLException("connection is null");
        }
    }

    private Connection getConnection() {
        return this.conn;
    }

    protected DBServiceImpl getService() {
        return this.service;
    }

    private void checkConnection() throws RemoteException {
        if (this.getConnection() == null) {
            throw new RemoteException("database connection not set.");
        }
    }

    protected void init() throws SQLException {
        try {
            this.checkConnection();
        }
        catch (RemoteException e) {
            throw new SQLException(e.getMessage());
        }
        if (this.isInitialized()) {
            return;
        }
        this.upper = Boolean.getBoolean(this.getService().getClass().getName() + ".uppercase");
        HashMap cachedMeta = ObjectMetaCache.getMetaData(this.getService().getClass(), this.getClass());
        if (cachedMeta != null) {
            this.types = cachedMeta;
            for (String s : cachedMeta.keySet()) {
                if (s == null) continue;
                this.properties.put(s, null);
            }
            return;
        }
        String tableName = this.getTableName();
        if (this.upper) {
            tableName = tableName.toUpperCase();
        }
        ResultSet meta = null;
        try {
            String schema = System.getProperty(this.getService().getClass().getName() + ".schema", null);
            try {
                meta = this.getConnection().getMetaData().getColumns(this.conn.getCatalog(), schema, tableName, null);
            }
            catch (Exception e) {
                Logger.trace((String)"unable to fetch table meta-data using NULL column name pattern, trying '%', see https://bugs.mysql.com/bug.php?id=81105");
                meta = this.getConnection().getMetaData().getColumns(this.conn.getCatalog(), schema, tableName, "%");
            }
            if (!meta.next()) {
                throw new SQLException("database table not found: " + tableName);
            }
            do {
                String field;
                if ((field = meta.getString("COLUMN_NAME")) == null || field.equalsIgnoreCase(this.getIDField())) continue;
                this.properties.put(this.upper ? field.toLowerCase() : field, null);
                this.types.put(this.upper ? field.toLowerCase() : field, meta.getString("TYPE_NAME"));
            } while (meta.next());
            ObjectMetaCache.setMetaData(this.getService().getClass(), this.getClass(), this.types);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                if (meta != null) {
                    meta.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean isInitialized() {
        return this.properties != null && this.properties.size() > 0 && this.types != null && this.types.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inTransaction() {
        Session session = transactions;
        synchronized (session) {
            Transaction t = this.getTransaction();
            return t != null && t.count > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transaction getTransaction() {
        Session session = transactions;
        synchronized (session) {
            return (Transaction)transactions.get((Object)this.getConnection());
        }
    }

    @Override
    public final void load(String id) throws RemoteException {
        this.checkConnection();
        String string = this.id = id == null || id.equals("") ? null : id;
        if (this.id == null) {
            return;
        }
        if (!this.isInitialized()) {
            throw new RemoteException("object not initialized.");
        }
        String tableName = this.getTableName();
        if (this.upper) {
            tableName = tableName.toUpperCase();
        }
        Statement stmt = null;
        ResultSet data = null;
        try {
            stmt = this.getConnection().createStatement();
            String load = this.getLoadQuery();
            Logger.debug((String)("executing query: " + load));
            data = stmt.executeQuery(load);
            if (!data.next()) {
                throw new ObjectNotFoundException("object [id: " + id + ", type: " + this.getClass().getName() + "] not found");
            }
            this.fill(data);
        }
        catch (SQLException e) {
            throw new RemoteException("unable to load data from table " + tableName, e);
        }
        finally {
            try {
                if (data != null) {
                    data.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    void fill(ResultSet rs) throws SQLException, RemoteException {
        String[] attributes = this.getAttributeNames();
        for (int i = 0; i < attributes.length; ++i) {
            Type t = TypeRegistry.getType((String)this.types.get(attributes[i]));
            this.setAttribute(attributes[i], t.get(rs, this.upper ? attributes[i].toUpperCase() : attributes[i]));
        }
        this.origProperties.putAll(this.properties);
    }

    @Override
    public void store() throws RemoteException, ApplicationException {
        if (this.isNewObject()) {
            this.insert();
        } else {
            this.update();
        }
    }

    @Override
    public final void clear() throws RemoteException {
        if (!this.isInitialized()) {
            throw new RemoteException("object not initialized.");
        }
        this.id = null;
        String[] attributes = this.getAttributeNames();
        for (int i = 0; i < attributes.length; ++i) {
            this.setAttribute(attributes[i], null);
        }
    }

    @Override
    public void delete() throws RemoteException, ApplicationException {
        if (this.isNewObject()) {
            return;
        }
        this.checkConnection();
        if (!this.isInitialized()) {
            throw new RemoteException("object not initialized.");
        }
        this.deleteCheck();
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            String sql = null;
            String tableName = this.getTableName();
            String idField = this.getIDField();
            if (this.upper) {
                tableName = tableName.toUpperCase();
                idField = idField.toUpperCase();
            }
            try {
                sql = "delete from " + tableName + " where " + idField + " = " + Integer.parseInt(this.id);
            }
            catch (NumberFormatException e) {
                sql = "delete from " + tableName + " where " + idField + " = '" + this.id + "'";
            }
            int count = stmt.executeUpdate(sql);
            if (count != 1) {
                throw new SQLException("delete failed, executeUpdate returned " + count);
            }
            if (!this.inTransaction()) {
                this.getConnection().commit();
            }
            this.notify(this.deleteListeners);
            this.id = null;
        }
        catch (SQLException e) {
            if (!this.inTransaction()) {
                try {
                    this.getConnection().rollback();
                    throw new RemoteException("delete failed, rollback successful", e);
                }
                catch (SQLException e2) {
                    throw new RemoteException("delete failed, rollback failed", e2);
                }
            }
            throw new RemoteException("delete failed", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public final String getID() throws RemoteException {
        return this.id;
    }

    public final void setID(String id) {
        this.id = id;
    }

    @Override
    public Object getAttribute(String fieldName) throws RemoteException {
        if (!this.isInitialized()) {
            throw new RemoteException("object not initialized.");
        }
        if (fieldName == null) {
            return null;
        }
        Object o = this.properties.get(fieldName);
        if (o == null) {
            if (fieldName.equalsIgnoreCase(this.getIDField())) {
                return this.getID();
            }
            return null;
        }
        if (o instanceof DBObject) {
            return o;
        }
        Class foreign = this.getForeignObject(fieldName);
        if (foreign != null) {
            String id = o.toString();
            DBObject cachedObject = (DBObject)this.foreignObjectCache.get(foreign.getName() + fieldName);
            if (cachedObject != null) {
                if (!id.equals(cachedObject.getID())) {
                    cachedObject.load(id);
                }
            } else {
                cachedObject = this.service.createObject(foreign, id);
                this.foreignObjectCache.put(foreign.getName() + fieldName, cachedObject);
            }
            return cachedObject;
        }
        return o;
    }

    @Override
    public final String getAttributeType(String attributeName) throws RemoteException {
        if (!this.isInitialized()) {
            throw new RemoteException("object not initialized.");
        }
        try {
            return (String)this.types.get(attributeName);
        }
        catch (Exception e) {
            throw new RemoteException("unable to determine filed type of attribute " + attributeName);
        }
    }

    protected boolean hasChanged() {
        try {
            String[] names = this.getAttributeNames();
            for (int i = 0; i < names.length; ++i) {
                if (!this.hasChanged(names[i])) continue;
                return true;
            }
            return false;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine object change state", (Throwable)re);
            return true;
        }
    }

    protected boolean hasChanged(String attribute) {
        String id;
        Object n;
        Object o = this.origProperties.get(attribute);
        if (o == (n = this.properties.get(attribute))) {
            return false;
        }
        if (o == null || n == null) {
            return true;
        }
        if (o instanceof AbstractDBObject) {
            id = ((AbstractDBObject)o).id;
            Integer n2 = o = id != null ? Integer.valueOf(Integer.parseInt(id)) : null;
        }
        if (n instanceof AbstractDBObject) {
            id = ((AbstractDBObject)n).id;
            Integer n3 = n = id != null ? Integer.valueOf(Integer.parseInt(id)) : null;
        }
        if (o == n) {
            return false;
        }
        if (o == null || n == null) {
            return true;
        }
        return !o.equals(n);
    }

    public Object setAttribute(String fieldName, Object value) throws RemoteException {
        if (fieldName == null) {
            return null;
        }
        return this.properties.put(fieldName, value);
    }

    @Override
    public final String[] getAttributeNames() throws RemoteException {
        Set s = this.properties.keySet();
        return s.toArray(new String[s.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLastId() throws SQLException, RemoteException {
        this.checkConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String tableName = this.getTableName();
            String idField = this.getIDField();
            if (this.upper) {
                tableName = tableName.toUpperCase();
                idField = idField.toUpperCase();
            }
            if (!(rs = (stmt = this.getConnection().createStatement()).executeQuery("select max(" + idField + ") from " + tableName)).next()) {
                throw new SQLException("select max(id) returned empty resultset");
            }
            String string = rs.getString(1);
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void insert() throws RemoteException, ApplicationException {
        this.checkConnection();
        if (!this.isInitialized()) {
            throw new RemoteException("object not initialized.");
        }
        this.insertCheck();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            boolean tx;
            stmt = this.getInsertSQL();
            stmt.executeUpdate();
            if (this.id == null) {
                try {
                    rs = stmt.getGeneratedKeys();
                    if (rs.next()) {
                        this.id = rs.getString(1);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (this.id == null) {
                this.id = this.getLastId();
            }
            this.created = tx = this.inTransaction();
            if (!tx) {
                this.getConnection().commit();
            }
            this.notify(this.storeListeners);
        }
        catch (SQLException e) {
            this.id = null;
            if (!this.inTransaction()) {
                try {
                    this.getConnection().rollback();
                    throw new RemoteException("insert failed, rollback successful", e);
                }
                catch (SQLException e2) {
                    throw new RemoteException("insert failed, rollback failed", e2);
                }
            }
            throw new RemoteException("insert failed", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void update() throws RemoteException, ApplicationException {
        this.checkConnection();
        if (!this.isInitialized()) {
            throw new RemoteException("object not initialized.");
        }
        if (this.isNewObject()) {
            throw new RemoteException("object is new - cannot update");
        }
        this.updateCheck();
        PreparedStatement stmt = null;
        int affected = 0;
        try {
            stmt = this.getUpdateSQL();
            if (stmt == null) {
                return;
            }
            affected = stmt.executeUpdate();
            if (affected != 1) {
                throw new SQLException("update ambiguous");
            }
            if (!this.inTransaction()) {
                this.getConnection().commit();
            }
            this.notify(this.storeListeners);
            this.origProperties.putAll(this.properties);
        }
        catch (SQLException e) {
            if (!this.inTransaction()) {
                try {
                    this.getConnection().rollback();
                    throw new RemoteException("update failed, rollback successful", e);
                }
                catch (SQLException e2) {
                    throw new RemoteException("update failed, rollback failed", e2);
                }
            }
            throw new RemoteException("update failed", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected PreparedStatement getUpdateSQL() throws RemoteException {
        this.checkConnection();
        String tableName = this.getTableName();
        String idField = this.getIDField();
        if (this.upper) {
            tableName = tableName.toUpperCase();
            idField = idField.toUpperCase();
        }
        String sql = "update " + tableName + " set ";
        String[] attributes = this.getAttributeNames();
        int count = 0;
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].equalsIgnoreCase(idField) || !this.hasChanged(attributes[i])) continue;
            sql = this.upper ? sql + attributes[i].toUpperCase() + "=?," : sql + attributes[i] + "=?,";
            ++count;
        }
        if (count == 0) {
            Logger.debug((String)"nothing changed in this object, skipping update");
            return null;
        }
        sql = sql.substring(0, sql.length() - 1);
        try {
            sql = sql + " where " + idField + "=" + Integer.parseInt(this.getID());
        }
        catch (NumberFormatException e) {
            sql = sql + " where " + idField + "='" + this.getID() + "'";
        }
        try {
            PreparedStatement stmt = this.getConnection().prepareStatement(sql);
            count = 0;
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i].equalsIgnoreCase(idField) || !this.hasChanged(attributes[i])) continue;
                String type = (String)this.types.get(attributes[i]);
                Object value = this.properties.get(attributes[i]);
                if (value instanceof DBObject) {
                    String id = ((DBObject)value).getID();
                    value = id != null ? Integer.valueOf(Integer.parseInt(id)) : null;
                }
                this.setStmtValue(stmt, count++, type, value);
            }
            Logger.debug((String)("executing sql statement: " + stmt.toString()));
            return stmt;
        }
        catch (Exception e) {
            throw new RemoteException("unable to prepare update sql statement", e);
        }
    }

    protected PreparedStatement getInsertSQL() throws RemoteException {
        this.checkConnection();
        String[] attributes = this.getAttributeNames();
        StringBuffer names = new StringBuffer();
        StringBuffer values = new StringBuffer();
        names.append("(");
        values.append(" values (");
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i] == null || attributes[i].length() == 0) continue;
            names.append(this.upper ? attributes[i].toUpperCase() : attributes[i]);
            values.append('?');
            if (i + 1 >= attributes.length) continue;
            names.append(',');
            values.append(',');
        }
        this.id = this.getID();
        if (this.id == null && this.getService().getInsertWithID()) {
            this.id = this.createID();
        }
        if (this.id != null) {
            names.append(',');
            names.append(this.upper ? this.getIDField().toUpperCase() : this.getIDField());
            values.append(',');
            try {
                values.append(Integer.parseInt(this.id));
            }
            catch (NumberFormatException e) {
                values.append('\'');
                values.append(this.id);
                values.append('\'');
            }
        }
        names.append(')');
        values.append(')');
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ");
            sql.append(this.upper ? this.getTableName().toUpperCase() : this.getTableName());
            sql.append(' ');
            sql.append(names.toString());
            sql.append(values.toString());
            PreparedStatement stmt = null;
            try {
                stmt = this.getConnection().prepareStatement(sql.toString(), 1);
            }
            catch (SQLException e) {
                stmt = this.getConnection().prepareStatement(sql.toString());
            }
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i] == null || attributes[i].length() == 0) continue;
                String type = (String)this.types.get(attributes[i]);
                Object value = this.properties.get(attributes[i]);
                if (value instanceof DBObject) {
                    String id = ((DBObject)value).getID();
                    value = id != null ? Integer.valueOf(Integer.parseInt(id)) : null;
                }
                this.setStmtValue(stmt, i, type, value);
            }
            Logger.debug((String)("executing sql statement: " + stmt.toString()));
            return stmt;
        }
        catch (Exception e) {
            throw new RemoteException("unable to prepare insert sql statement", e);
        }
    }

    private String createID() throws RemoteException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String tableName = this.getTableName();
            String idField = this.getIDField();
            if (this.upper) {
                tableName = tableName.toUpperCase();
                idField = idField.toUpperCase();
            }
            if (!(rs = (stmt = this.getConnection().createStatement()).executeQuery("select (max(" + idField + ") + 1) from " + tableName)).next()) {
                throw new SQLException("select max(id) returned empty resultset");
            }
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException e) {
            throw new RemoteException("unable to create new insert id", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected String getListQuery() {
        String tableName = this.getTableName();
        if (this.upper) {
            tableName = tableName.toUpperCase();
        }
        return "select " + tableName + ".* from " + tableName;
    }

    protected String getLoadQuery() throws RemoteException {
        String tableName = this.getTableName();
        String idField = this.getIDField();
        if (this.upper) {
            tableName = tableName.toUpperCase();
            idField = idField.toUpperCase();
        }
        try {
            return "select * from " + tableName + " where " + idField + " = " + Integer.parseInt(this.getID());
        }
        catch (NumberFormatException e) {
            return "select * from " + tableName + " where " + idField + " = '" + this.getID() + "'";
        }
    }

    private void setStmtValue(PreparedStatement stmt, int index, String type, Object value) throws SQLException {
        Type t = TypeRegistry.getType(type);
        t.set(stmt, ++index, value);
    }

    @Override
    public final boolean isNewObject() throws RemoteException {
        return this.getID() == null;
    }

    protected String getIDField() {
        return this.upper ? "ID" : "id";
    }

    protected abstract String getTableName();

    @Override
    public abstract String getPrimaryAttribute() throws RemoteException;

    protected void deleteCheck() throws ApplicationException {
    }

    protected void insertCheck() throws ApplicationException {
    }

    protected void updateCheck() throws ApplicationException {
    }

    protected Class getForeignObject(String field) throws RemoteException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void transactionBegin() throws RemoteException {
        Session session = transactions;
        synchronized (session) {
            this.checkConnection();
            Transaction tr = this.getTransaction();
            if (tr == null) {
                tr = new Transaction();
            }
            tr.count++;
            if (tr.count > 5) {
                Logger.warn((String)("[begin] transaction count: " + tr.count + " - forgotten to rollback/commit?"));
            }
            Logger.debug((String)("[begin] transaction count: " + tr.count));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void transactionRollback() throws RemoteException {
        Session session = transactions;
        synchronized (session) {
            if (this.created) {
                this.id = null;
                this.created = false;
            }
            if (!this.inTransaction()) {
                Logger.debug((String)"[rollback] rollback without begin or transaction allready rolled back");
                return;
            }
            this.checkConnection();
            Transaction tr = this.getTransaction();
            if (tr == null) {
                Logger.debug((String)"[rollback] rollback called, but no transaction found");
                return;
            }
            tr.count--;
            Logger.debug((String)("[rollback] transaction count: " + tr.count));
            if (tr.count > 0) {
                return;
            }
            try {
                Logger.debug((String)"[rollback] transaction rollback");
                this.getConnection().rollback();
            }
            catch (SQLException e) {
                throw new RemoteException("rollback failed", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void transactionCommit() throws RemoteException {
        Session session = transactions;
        synchronized (session) {
            if (!this.inTransaction()) {
                Logger.debug((String)"[commit] transaction commit without begin or transaction allready commited, skipping");
                return;
            }
            this.checkConnection();
            Transaction tr = this.getTransaction();
            if (tr == null) {
                Logger.debug((String)"[commit] commit called, but no transaction found");
                return;
            }
            tr.count--;
            Logger.debug((String)("[commit] transaction count: " + tr.count));
            if (tr.count > 0) {
                return;
            }
            try {
                Logger.debug((String)"[commit] transaction commit");
                this.getConnection().commit();
                this.created = false;
            }
            catch (SQLException se) {
                try {
                    this.getConnection().rollback();
                    throw new RemoteException("commit failed, rollback successful", se);
                }
                catch (SQLException se2) {
                    throw new RemoteException("commit failed, rollback failed", se2);
                }
            }
        }
    }

    @Override
    public DBIterator getList() throws RemoteException {
        return new DBIteratorImpl<AbstractDBObject>(this, this.service);
    }

    @Override
    public void overwrite(DBObject object) throws RemoteException {
        if (object == null) {
            return;
        }
        if (!object.getClass().equals(this.getClass())) {
            return;
        }
        String[] attributes = this.getAttributeNames();
        for (int i = 0; i < attributes.length; ++i) {
            Class foreign = this.getForeignObject(attributes[i]);
            if (foreign != null) {
                DBObject fObject = (DBObject)object.getAttribute(attributes[i]);
                if (fObject == null) continue;
                this.setAttribute(attributes[i], fObject.getID());
                continue;
            }
            this.setAttribute(attributes[i], object.getAttribute(attributes[i]));
        }
    }

    @Override
    public boolean equals(GenericObject other) throws RemoteException {
        if (other == null) {
            return false;
        }
        DBObject o = null;
        try {
            o = (DBObject)other;
        }
        catch (ClassCastException e) {
            return false;
        }
        String id = o.getID();
        String className = o.getClass().getName();
        if (id == null) {
            return false;
        }
        return this.getClass().getName().equals(className) && id.equals(this.getID());
    }

    @Override
    public synchronized void addDeleteListener(Listener l) throws RemoteException {
        if (this.deleteListeners == null) {
            this.deleteListeners = new ArrayList();
        }
        this.deleteListeners.add(l);
    }

    @Override
    public synchronized void addStoreListener(Listener l) throws RemoteException {
        if (this.storeListeners == null) {
            this.storeListeners = new ArrayList();
        }
        this.storeListeners.add(l);
    }

    @Override
    public void removeDeleteListener(Listener l) throws RemoteException {
        if (this.deleteListeners == null) {
            return;
        }
        this.deleteListeners.remove(l);
    }

    @Override
    public void removeStoreListener(Listener l) throws RemoteException {
        if (this.storeListeners == null) {
            return;
        }
        this.storeListeners.remove(l);
    }

    private synchronized void notify(ArrayList listeners) throws RemoteException {
        if (listeners == null) {
            return;
        }
        Event e = new Event(){

            @Override
            public DBObject getObject() throws RemoteException {
                return AbstractDBObject.this;
            }
        };
        for (int i = 0; i < listeners.size(); ++i) {
            ((Listener)listeners.get(i)).handleEvent(e);
        }
    }

    private class Transaction {
        private int count = 0;
        private Connection myConn = null;

        private Transaction() {
            this.myConn = AbstractDBObject.this.getConnection();
            transactions.put((Object)this.myConn, (Object)this);
        }
    }
}

